<?php
/**
 *
 * CMS osRealty 2.1.x
 * Autor: Roman Chernyshov
 * E-mail: support@osRealty.ru
 * URL: www.osRealty.ru
 *
 */



/**
 *
 *  Пример использования
 *
 *  $category = new TreeCategory ($DB); // передаем в класс интерфес работы с БД
 *  $category->table='category'; // запрос на выборку списка категорий, название таблицы
 *  $category->outCategory($category->getCategory()); // подготовка вывода категорий(запрос массива категорий)
 *  echo $category->html; // вывод категорий в HTML <option value="id">name</option>
 *
 */


/**
 *  Дамп таблицы с которой ведется работа
 *
 *  DROP TABLE IF EXISTS `category`;
 *  CREATE TABLE `category` (
 *    `id` int(11) NOT NULL auto_increment,
 *    `podcat` int(11) NOT NULL,
 *    `name` varchar(255) NOT NULL,
 *    PRIMARY KEY  (`id`),
 *    KEY `id` (`id`)
 *  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
 *  
 */


class TreeCategory {
	/**
	*   Строка запроса в БД
	*/
	var $table;

	/**
	*   Интерфейс работы с БД
	*/
	var $DB;

	/**
	*   Массив категорий с вложенными подкатегориями
	*/
	var $arrayCat;

	/**
	*   Авто-подстчет кол-ва прочерков перед названием категории при выводе
	*/
	var $countPodcat;

	/**
	*   HTML код для вывода категорий с подкатегориями
	*/
	var $html;


	/**
	*   Получаем интерфейс для работы с БД и кладем его в локальные переменную
	*/
	function __construct($DB) {
		$this->DB=$DB;
		$this->component=$_GET['component'];
	}


	/**
	*   Получает список категорий, сортирует и помещает в массив с вложенными массивами и т.д.
	*   @return array category
	*/
	function getCategory () {
 	  $all = $this->DB->getAll("SELECT * FROM `{$this->table}` ORDER BY `id` ASC");
          $path = array();
	  if(count($all)>0) {
	   foreach($all as $item):
		if($item['podcat']==0)$sort[$item['id']]=$item;
		if($item['podcat']>0)
			{
			if(isset($path[$item['podcat']]))
				{
				$str='$sort';
				foreach($path[$item['podcat']] as $pitem):
					$rep=$item['podcat'];
					$str.="[$pitem][sub]";
				endforeach;
				$str.="[{$item['podcat']}][sub]";

				$str.="[{$item['id']}]";
                                $str.='=$item;';

				eval($str);

				foreach($path[$item['podcat']] as $pitem):
					$path[$item['id']][]=$pitem;
				endforeach;

				$path[$item['id']][]=$item['podcat'];
				}
				else
				{
				$sort[$item['podcat']]['sub'][$item['id']]=$item;
				$path[$item['id']][]=$item['podcat'];
				}
			}
           endforeach;
           }
           $this->arrayCat=$sort;
	   return $this->arrayCat;
        }


        /**
        *   Печатает категории, помещает готовый HTML в $this->html
	*   @param array Массив с категориями и вложенными подкатегориями
	*   @param string Тип генерируемого HTML кода для вывода, option или table
        */
        function outCategory(&$arrayCat, $type='option', $idSel=0) {
		foreach($arrayCat as $sub) {
		  $this->countPodcat++;
		  $this->outItem($sub, $type);
		  if(!empty($sub['sub']))$this->outCategory($sub['sub'], $type, $idSel);
		  $this->countPodcat--;
		}
	}

	/**
	*   Вспомогательный метод подготовки HTML кода
	*   @param array Массив с категорией
	*   @param string Тип генерируемого HTML кода для вывода, option или table
	*/
        function outItem($sub, $type='option', $idSel=0) {
                for($i=0;$i<=$this->countPodcat;$i++) {
                        $out.='-';
			}
		if($idSel==$sub['id'])$se='selected'; else $se='';
		if($type=='option')$this->html.="<option value=\"{$sub['id']}\" {$se}>{$out} {$sub['name']}</option>";
		if($type=='table')$this->html.= <<<HTML
			<tr><td class="name" width="450">{$out} <img src="images/index.png" width="16" height="16" border="0" alt="{$sub['name']}" />
			{$sub['name']}</td>
			<td align="center"><a href="?component={$this->component}&section=edit&id={$sub['id']}">
				<img src="images/user_edit.png" alt="edit" title="edit" border="0" /></a></td>
			<td align="center"><a href="?component={$this->component}&section=delete&id={$sub['id']}" class="ask">
			<img src="images/trash.png" alt="del" title="del" border="0" /></a></td></tr>
HTML;

	}

	function delCategory(&$a_tree,&$id=0) {
		foreach($a_tree as $sub) {
			if($sub['id']<>$id and isset($sub['sub']))$this->delCategory($sub['sub'],$id);
			if($sub['id']==$id) {
				$sql="DELETE FROM {$this->table} WHERE id = '$id' LIMIT 1";
				$this->DB->execute($sql);
				if (isset($sub['sub'])) $this->delCategory_process($sub['sub']);
			}
		}
	}

	function delCategory_process(&$a_tree) {
		foreach($a_tree as $sub) {
			$sql="DELETE FROM {$this->table} WHERE id = '{$sub['id']}' LIMIT 1";
			$this->DB->execute($sql);
			if(isset($sub['sub']))$this->delCategory_process($sub['sub']);
		}
	}


	function updateItem() {
		$name=$this->PHP_slashes(strip_tags($_POST['name']));
		$podcat=intval($_POST['podcat']);
		$id=intval($_POST['id']);
		$sql="UPDATE `{$this->table}` SET `name` = '{$name}',`podcat` = '{$podcat}'
			WHERE `id`='{$id}' LIMIT 1; ";
		$this->DB->execute($sql);

	}

	function addItem() {
		$name=$this->PHP_slashes(strip_tags($_POST['name']));
		$podcat=intval($_POST['podcat']);
		$id=intval($_POST['id']);
		$sql="INSERT INTO `{$this->table}` (`id`,`podcat`,`name`) VALUES ('', '$podcat', '$name');";
		$this->DB->execute($sql);

	}

	function deleteItem($id) {
		$id=intval($id);
		$sql="DELETE FROM `{$this->table}` WHERE `id` = '{$id}' LIMIT 1";
		$DB->execute($sql);
		header("Location: ?component={$this->component}");
	}

	function PHP_slashes($string,$type='add') {
	    if ($type == 'add') {
	        if (get_magic_quotes_gpc()) {
	            return $string;
	            }
	        else {
	            if (function_exists('addslashes')) {
	                return addslashes($string);
		    }
	            else {
	                return mysql_real_escape_string($string);
	            }
	        }
	    }
	    else if ($type == 'strip') {
	        return stripslashes($string);
	    }
	    else {
	        die('error in PHP_slashes (mixed,add | strip)');
	    }
	}

}
