<?php

/*
Plugin Name: RCHE If-Modified-Since Support
Description: Добавляет поддержку для If-Modified-Since HTTP заголовков при запросе к сайту и отдает ответ 304 Not Modified.
Version: 1.0
Author: rche.ru
Plugin URI: https://rche.ru/6310_plagin-dlya-wordpress-podderzhka-zagolovka-if-modified-since.html
*/

if (!defined('ABSPATH')) {
    exit; 
}

class If_Modified_Since_Support {

    public function __construct() {
        add_action('template_redirect', array($this, 'handle_if_modified_since'), 10);
        add_action('template_redirect', array($this, 'send_last_modified_header'), 20);
    }

    public function handle_if_modified_since() {

        if (is_admin() || $_SERVER['REQUEST_METHOD'] === 'POST' || current_user_can('edit_posts')) {
            return;
        }

        if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
            $last_modified = $this->get_last_modified_header();
            $if_modified_since = strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']);
            
            if ($if_modified_since >= $last_modified) {
                header('HTTP/1.1 304 Not Modified');
                exit;
            }
        }
    }


    public function send_last_modified_header() {

        if (is_admin() || $_SERVER['REQUEST_METHOD'] === 'POST' || current_user_can('edit_posts')) {
            return;
        }

        $last_modified = $this->get_last_modified_header();
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $last_modified) . ' GMT');
    }


    private function get_last_modified_header() {
        global $post;
        
        if (is_singular()) {
            return strtotime($post->post_modified_gmt);
        }
        
        if (is_archive() || is_home() || is_front_page()) {
            $posts = get_posts(array(
                'numberposts' => 1,
                'orderby' => 'modified',
                'order' => 'DESC',
                'post_status' => 'publish',
                'post_type' => $this->get_queried_post_types()
            ));
            
            if (!empty($posts)) {
                return strtotime($posts[0]->post_modified_gmt);
            }
        }
        
        return time();
    }

    private function get_queried_post_types() {
        if (is_home() || is_front_page()) {
            return 'post';
        }
        
        if (is_post_type_archive()) {
            $post_type = get_queried_object();
            return $post_type ? $post_type->name : 'post';
        }
        
        return 'any';
    }
}

new If_Modified_Since_Support();